# Django Rest Framework
from rest_framework.views import APIView
from rest_framework.response import Response

# Project
from .permissions import IsSaferoad
from .serializer import FineSerializer
from apps.logs.utils import log_http_input_request


class FinesWebhookView(APIView):
    permission_classes = (IsSaferoad,)

    def post(self, request, *args, **kwargs):
        serializer = FineSerializer(data=request.data)

        if serializer.is_valid():
            serializer.save()
            response = Response({
                "code": 0,
                "message": "Success"
            })
        else:
            response = Response(serializer.errors)

        log_http_input_request(request, response)
        return response
