# Stdlib
from unittest.mock import patch, Mock

# Django Rest Framework
from rest_framework.test import APITestCase

# Project
from apps.cars.models import CarDetail
from apps.shared.tests import ViewSetTestCase, AuthTestCase
from apps.cars.tasks import get_cars_date_of_registration


class InspectionTaskTest(APITestCase, ViewSetTestCase, AuthTestCase):
    fixtures = [
        'user.yaml',
        'car_detail.yaml',
        'violation.yaml',
        'violation_translation.yaml',
        'fines.yaml',
        'file.yaml',
    ]

    @patch('apps.cars.services.inspection._get_token', return_value=None)
    @patch('apps.cars.tasks.requests.post')
    def test_task_get_date_of_registration_success(self, mock_post, *_):
        mock = Mock()
        mock.status_code = 200
        mock.json.return_value = {
            'pDateRegistration': "2019-01-12T00:00:00",
            'Year': "2018"
        }

        mock_post.return_value = mock

        self.assertEqual(CarDetail.objects.filter(
            is_checked_tech_passport=False).count(), 4)

        get_cars_date_of_registration()
        self.assertEqual(CarDetail.objects.filter(
            date_of_registration__isnull=True).count(), 0)
