# Django Rest Framework
from rest_framework.test import APITestCase
from rest_framework import status

# Project
from apps.shared.tests import ViewSetTestCase, AuthTestCase


class CarModelTest(APITestCase, ViewSetTestCase, AuthTestCase):
    fixtures = [
        'car_model.yaml',
        'car_brand.yaml',
        'file.yaml',
        'user.yaml'
    ]

    url = 'mobile:car_models-%s'

    def setUp(self):
        self._auth_admin()

    def test_unauth(self):
        self.client.credentials()

        response = self._list()
        self.assertEqual(response.status_code, status.HTTP_403_FORBIDDEN)

        response = self._retrieve({'pk': 1})
        self.assertEqual(response.status_code, status.HTTP_403_FORBIDDEN)

    def test_retrieve(self):
        response = self._retrieve({'pk': 1})
        self.assertEqual(response.status_code, status.HTTP_200_OK)
        self.assertEqual(response.data, {
            "id": 1,
            "car_brand": 1,
            "name": "Nexia",
            "image": {
                'id': 1,
                'name': 'my_file',
                'file': 'http://testserver/media/test.jpg'
            }
        })

    def test_list(self):
        response = self._list()
        self.assertEqual(response.status_code, status.HTTP_200_OK)
        self.assertEqual(response.data['count'], 5)
        self.assertEqual(len(response.data['results']), 5)
        self.assertEqual(response.data['results'][0], {
            "id": 1,
            "car_brand": 1,
            "name": "Nexia",
            "image": {
                'id': 1,
                'name': 'my_file',
                'file': 'http://testserver/media/test.jpg'
            }
        })

    def test_list_filter_car_brand(self):
        response = self._list({'car_brand': 1})
        self.assertEqual(response.status_code, status.HTTP_200_OK)
        self.assertEqual(response.data['count'], 3)
        self.assertEqual(len(response.data['results']), 3)
        self.assertEqual(response.data['results'][0], {
            "id": 1,
            "car_brand": 1,
            "name": "Nexia",
            "image": {
                'id': 1,
                'name': 'my_file',
                'file': 'http://testserver/media/test.jpg'
            }
        })

    def test_pagination(self):
        response = self._list({'page_size': 2})
        self.assertEqual(response.status_code, status.HTTP_200_OK)
        self.assertEqual(response.data['count'], 5)
        self.assertEqual(len(response.data['results']), 2)
