# Django Rest Framework
from rest_framework.test import APITransactionTestCase
from rest_framework import status

# Project
from apps.shared.tests import ViewSetTestCase, AuthTestCase
from ..models import Car, Confidant, Insurance, Tinting


class CarAdminTest(APITransactionTestCase, ViewSetTestCase, AuthTestCase):
    fixtures = [
        'user.yaml',
        'cars.yaml',
        'car_brand.yaml',
        'car_model.yaml',
        'car_detail.yaml',
        'confidant.yaml',
        'inspection_places.yaml',
        'old_inspections.yaml',
        'insurance.yaml',
        'tinting.yaml',
        'oil.yaml',
        'violation.yaml',
        'violation_translation.yaml',
        'fines.yaml',
        'file.yaml',
        'inspections.yaml'
    ]

    url = 'myadmin:car-%s'

    def setUp(self):
        self._auth_admin()

    def test_unauth(self):
        self.client.credentials()

        response = self._create({})
        self.assertEqual(response.status_code, status.HTTP_403_FORBIDDEN)

        response = self._list()
        self.assertEqual(response.status_code, status.HTTP_403_FORBIDDEN)

        response = self._retrieve({'pk': 1})
        self.assertEqual(response.status_code, status.HTTP_403_FORBIDDEN)

        response = self._destroy({'pk': 1})
        self.assertEqual(response.status_code, status.HTTP_403_FORBIDDEN)

    def test_non_admin(self):
        self._auth_non_admin()

        response = self._create({})
        self.assertEqual(response.status_code, status.HTTP_403_FORBIDDEN)

        response = self._list({})
        self.assertEqual(response.status_code, status.HTTP_403_FORBIDDEN)

        response = self._retrieve({'pk': 1})
        self.assertEqual(response.status_code, status.HTTP_403_FORBIDDEN)

        response = self._destroy({'pk': 1})
        self.assertEqual(response.status_code, status.HTTP_403_FORBIDDEN)

    def test_list(self):
        response = self._list()
        self.assertEqual(response.status_code, status.HTTP_200_OK)
        self.assertEqual(response.data['count'], 4)
        self.assertEqual(len(response.data['results']), 4)
        self.assertEqual(
            response.data['results'][1],
            {
                "id": 2,
                "number": "01A124AA",
                "tech_pass_num": "123454",
                "tech_pass_series": "AAA",
                "mark": "Tesla2",
                "name": "Krutaya tachka2",
                'image': None,
                'car_model': {
                    'id': 2,
                    "car_brand": 2,
                    'name': 'Matiz',
                    'image': {
                        'id': 2,
                        'name': 'my_file2',
                        'file': 'http://testserver/media/test.jpg'
                    }
                },
                'car_brand': {
                    'id': 2,
                    'name': 'Ravon',
                    'logo': {
                        'id': 2,
                        'name': 'my_file2',
                        'file': 'http://testserver/media/test.jpg'
                    }
                },
                'fines_count': 0,
                'fines_remain': 0.00,
                "car_detail": 2,
                'date_of_registration': None,
                'year_manufacture': None,
                'pinned': False,
                'user': 1,
                'user_phone_number': '+999999999990',
                'is_deleted': False
            }
        )

    def test_pagination(self):
        response = self._list({'page_size': 2})
        self.assertEqual(response.status_code, status.HTTP_200_OK)
        self.assertEqual(response.data['count'], 4)
        self.assertEqual(len(response.data['results']), 2)

    def test_list_filter_plate_number(self):
        response = self._list({'car_detail__number': '01A124AA'})
        self.assertEqual(response.status_code, status.HTTP_200_OK)
        self.assertEqual(response.data['count'], 1)
        self.assertEqual(len(response.data['results']), 1)
        self.assertEqual(response.data['results'][0]['id'], 2)

    def test_list_filter_pSeryNumber(self):
        response = self._list({'pSeryNumber': 'RA20140040419'})
        self.assertEqual(response.status_code, status.HTTP_200_OK)
        self.assertEqual(response.data['count'], 1)
        self.assertEqual(len(response.data['results']), 1)
        self.assertEqual(response.data['results'][0]['id'], 1)
