# Django
from django.db import models

# Project
from apps.shared.models import BaseModel


class Tinting(BaseModel):
    BACK = 'back'
    SIDE = 'side'

    KIND_CHOICES = (
        (BACK, 'back'),
        (SIDE, 'side')
    )

    car = models.ForeignKey(
        'cars.Car',
        on_delete=models.CASCADE,
        related_name='tintings'
    )
    kind = models.CharField(max_length=30, choices=KIND_CHOICES)
    series = models.CharField(max_length=30)
    number = models.CharField(max_length=50)
    date_passed = models.DateField()
    date_end = models.DateField()
