# Django
from django.db import models

# Project
from apps.shared.models import BaseModel


class Oil(BaseModel):
    car = models.ForeignKey(
        'cars.Car',
        on_delete=models.PROTECT,
        related_name='oils'
    )
    mark = models.CharField(max_length=30)
    mileage = models.IntegerField()
    next_mileage = models.IntegerField()
    charge_price = models.IntegerField()
    last_replacement = models.DateField()
    next_replacement = models.DateField()
    daily_mileage = models.PositiveIntegerField(null=True)
    oil_mileage = models.PositiveIntegerField(null=True)
