# Django
from django.db import models

# Project
from apps.shared.models import BaseModel


class Insurance(BaseModel):
    KASKO = 'kasko'
    OSAGO = 'osago'
    OTHER = 'other'

    KIND_CHOICES = (
        (KASKO, 'КАСКО'),
        (OSAGO, "ОСАГО"),
        (OTHER, "Другие")
    )

    car = models.ForeignKey(
        'cars.Car',
        on_delete=models.CASCADE,
        related_name='insurances'
    )
    kind = models.CharField(max_length=30, choices=KIND_CHOICES)
    series = models.CharField(max_length=30)
    number_of_drivers = models.IntegerField()
    company_name = models.CharField(max_length=50)
    number = models.CharField(max_length=50)
    date_passed = models.DateField()
    date_end = models.DateField()
