# Django
from django.db import models
from django.db.models import UniqueConstraint, Q

# Project
from apps.shared.models import BaseModel, BaseMeta


class InspectionPlace(BaseModel):
    name = models.CharField(max_length=50)


class OldInspection(BaseModel):
    car = models.ForeignKey(
        'cars.Car',
        on_delete=models.CASCADE,
        related_name='inspections'
    )
    place = models.ForeignKey(
        InspectionPlace,
        on_delete=models.PROTECT
    )
    date_passed = models.DateField()
    date_end = models.DateField()


class Inspection(BaseModel):
    car_detail = models.ForeignKey(
        'cars.CarDetail',
        on_delete=models.CASCADE,
        related_name='inspections'
    )
    dateInpsection = models.DateTimeField()
    dateNextInpsection = models.DateTimeField(null=True)
    pDivision = models.CharField(max_length=255)
    value = models.JSONField()

    class Meta(BaseMeta):
        constraints = [
            UniqueConstraint(
                fields=['dateInpsection', 'car_detail'],
                condition=Q(is_deleted=False),
                name='unique_inspection_date'
            )
        ]
