# Django
from django.db import models

# Project
from apps.shared.models import BaseModel


class CarBrand(BaseModel):
    name = models.CharField(max_length=50, unique=True)
    popular = models.IntegerField(default=0)
    logo = models.ForeignKey(
        'files.File',
        null=True,
        on_delete=models.SET_NULL
    )

    class Meta:
        ordering = ('-popular',)


class CarModel(BaseModel):
    name = models.CharField(max_length=50)
    popular = models.IntegerField(default=0)
    image = models.ForeignKey(
        'files.File',
        null=True,
        on_delete=models.SET_NULL
    )
    car_brand = models.ForeignKey(CarBrand, on_delete=models.CASCADE)

    class Meta:
        ordering = ('-popular',)
