# Django
from django.db import models
from django.db.models import Q

# Pypi: django-parler
from parler.models import TranslatableModel, TranslatedFields

# Project
from apps.cars.managers.fine import FineManager
from apps.shared.models import BaseModel, BaseMeta


class Violation(TranslatableModel):
    translations = TranslatedFields(
        desc=models.CharField(max_length=655)
    )

    article = models.CharField(max_length=255)
    part = models.IntegerField(null=True)
    discount = models.FloatField(null=True)


class Fine(BaseModel):
    """
    pStatus meaning:
    1: Сформировано постановление
    2: Постановление отменено
    3: Приближается срок отправки постановления в МИБ
    4: Принята оплата за штраф в размере .... суммы
    5: Постановление закрыто
    """
    PARENT_STATUSES = [1, 2, 3, 5]
    CHILD_STATUS = 4

    pSeryNumber = models.CharField(max_length=255)
    pPlace = models.CharField(max_length=655, blank=True)
    pLocation = models.CharField(max_length=655, blank=True)
    pDate = models.DateTimeField()
    pViolation = models.ForeignKey(Violation, on_delete=models.PROTECT)
    pAmount = models.DecimalField(max_digits=14, decimal_places=2)
    pStatus = models.SmallIntegerField()
    pUrl = models.CharField(max_length=655, blank=True, null=True)
    is_exist_pdf = models.BooleanField(default=True)

    pdf = models.ForeignKey(
        'files.File',
        null=True,
        on_delete=models.SET_NULL,
        related_name='fine_pdf'
    )
    plate_number = models.ForeignKey(
        'files.File',
        null=True,
        on_delete=models.SET_NULL,
        related_name='fine_plate_number'
    )
    plate_number_and_car = models.ForeignKey(
        'files.File',
        null=True,
        on_delete=models.SET_NULL,
        related_name='fine_plate_number_car'
    )
    car_detail = models.ForeignKey(
        'cars.CarDetail',
        on_delete=models.CASCADE,
        related_name='fines'
    )
    remain = models.DecimalField(max_digits=14, decimal_places=2, default=0)
    date_of_ruling = models.DateField(null=True)
    parent = models.ForeignKey(
        'self',
        on_delete=models.CASCADE,
        related_name='child',
        null=True
    )
    is_fail_http_request_remain = models.BooleanField(default=False)
    objects = FineManager()

    class Meta(BaseMeta):
        constraints = [
            models.UniqueConstraint(
                fields=['pSeryNumber'],
                condition=(
                    Q(is_deleted=False) &
                    Q(pStatus__in=[1, 2, 3, 5])
                ),
                name='unique_parent_fine'
            )
        ]
