# Django
from django.db import models

# Project
from apps.shared.models import BaseModel


class Confidant(BaseModel):
    ONE_TIME = 'one_time'
    SPECIAL = 'special'
    GENERAL = 'general'

    KIND_CHOICES = (
        (ONE_TIME, 'Разовая'),
        (SPECIAL, 'Специальная'),
        (GENERAL, 'Общая')
    )

    car = models.ForeignKey(
        'cars.Car',
        on_delete=models.CASCADE,
        related_name='confidants'
    )
    kind = models.CharField(max_length=30, choices=KIND_CHOICES)
    series = models.CharField(max_length=30)
    number = models.CharField(max_length=50)
    issued_to = models.CharField(max_length=200)
    date_passed = models.DateField()
    date_end = models.DateField()
