# Django
from django.db import models

# Project
from apps.shared.models import BaseModel, BaseMeta


class CarDetail(BaseModel):
    number = models.CharField(max_length=10)
    is_subscribed = models.BooleanField(default=False)
    require_unsubscribe = models.BooleanField(default=False)
    tech_pass_num = models.CharField(max_length=10)
    tech_pass_series = models.CharField(max_length=3)
    date_of_registration = models.DateTimeField(null=True)
    year_manufacture = models.IntegerField(null=True)
    is_checked_tech_passport = models.BooleanField(default=False)

    class Meta(BaseMeta):
        constraints = [
            models.UniqueConstraint(
                fields=['number', 'tech_pass_num', 'tech_pass_series'],
                condition=models.Q(is_deleted=False),
                name='unique_car_detail'
            )
        ]


class Car(BaseModel):
    user = models.ForeignKey(
        'gauth.User',
        on_delete=models.PROTECT,
        related_name='cars'
    )
    car_detail = models.ForeignKey(
        CarDetail,
        on_delete=models.PROTECT,
        related_name='cars'
    )
    mark = models.CharField(max_length=30)
    name = models.CharField(max_length=50)
    image = models.ForeignKey(
        'files.File',
        null=True,
        on_delete=models.SET_NULL
    )
    car_brand = models.ForeignKey(
        'cars.CarBrand',
        null=True,
        on_delete=models.SET_NULL
    )
    car_model = models.ForeignKey(
        'cars.CarModel',
        null=True,
        on_delete=models.SET_NULL
    )
    pinned = models.BooleanField(default=False)

    @property
    def confidant(self):
        return self.confidants.order_by('-date_end').first()

    @property
    def inspection(self):
        return self.inspections.order_by('-date_end').first()

    @property
    def insurance(self):
        return self.insurances.order_by('-date_end').first()

    @property
    def tinting(self):
        return self.tintings.order_by('-date_end').first()

    @property
    def oil(self):
        return self.oils.order_by('-next_replacement').first()

    class Meta(BaseMeta):
        constraints = [
            models.UniqueConstraint(
                fields=['user', 'car_detail'],
                condition=models.Q(is_deleted=False),
                name='unique_car_detail_and_user'
            )
        ]
