# Django Rest Framework
from rest_framework.permissions import IsAuthenticated
from rest_framework.viewsets import ReadOnlyModelViewSet

# Project
from ...models import InspectionPlace
from ..serializers.inspection import InspectionPlaceSerializer


class InspectionPlaceViewSet(ReadOnlyModelViewSet):
    queryset = InspectionPlace.objects.all()
    permission_classes = (IsAuthenticated,)
    serializer_class = InspectionPlaceSerializer
