# Django Rest Framework
from rest_framework.permissions import IsAuthenticated
from rest_framework.viewsets import ReadOnlyModelViewSet

# Project
from ...models import CarBrand, CarModel
from ..serializers.handbooks import CarBrandSerializer, CarModelSerializer


class CarBrandViewSet(ReadOnlyModelViewSet):
    permission_classes = (IsAuthenticated,)
    serializer_class = CarBrandSerializer
    queryset = CarBrand.objects.all()


class CarModelViewSet(ReadOnlyModelViewSet):
    permission_classes = (IsAuthenticated,)
    serializer_class = CarModelSerializer
    queryset = CarModel.objects.all()
    filterset_fields = ['car_brand']
