# Django
from django.db.models import Q, Count, Sum
from django.db.models.functions import Coalesce

# Django Rest Framework
from rest_framework.permissions import IsAuthenticated
from rest_framework.viewsets import ModelViewSet
from rest_framework.response import Response
from rest_framework import status

# Project
from ...models import Car
from ..serializers.car import CarSerializer
from ...services.cars import delete_car


class CarViewSet(ModelViewSet):
    permission_classes = (IsAuthenticated,)
    serializer_class = CarSerializer

    def get_queryset(self):
        queryset = Car.objects.filter(user=self.request.user)
        queryset = queryset.annotate(
            fines_remain=Coalesce(Sum(
                'car_detail__fines__remain',
                filter=Q(car_detail__fines__pStatus__in=[1, 3])
            ), 0),
            fines_count=Count('car_detail__fines', filter=Q(
                car_detail__fines__pStatus__in=[1, 3],
            ))
        )

        return queryset

    def destroy(self, request, *args, **kwargs):
        delete_car(self.get_object())
        return Response(status=status.HTTP_204_NO_CONTENT)
