# Django
from django.urls import include, path
from rest_framework.routers import DefaultRouter

# Project
from .views.car import CarViewSet
from .views.handbooks import CarBrandViewSet, CarModelViewSet
from .views.fine import FineViewSet, PaymentsAPIView
from .views.inspection import InspectionViewSet
from .views.inspection_places import InspectionPlaceViewSet

router = DefaultRouter()
router.register('inspections', InspectionViewSet, 'inspections')
router.register(
    'inspection-places', InspectionPlaceViewSet, 'inspection-places'
)
router.register('car_brands', CarBrandViewSet, 'car_brands')
router.register('car_models', CarModelViewSet, 'car_models')
router.register('fine', FineViewSet, 'fines')
router.register('', CarViewSet, 'cars')

urlpatterns = [
    path('', include(router.urls)),
    path('payments', PaymentsAPIView.as_view(), name='payments-list')
]
