# Django Rest Framework
from rest_framework import serializers

# Project
from ...models import Insurance


class InsuranceSerializer(serializers.ModelSerializer):
    class Meta:
        model = Insurance
        fields = (
            'id',
            'kind',
            'number_of_drivers',
            'company_name',
            'series',
            'number',
            'date_passed',
            'date_end'
        )

    def validate_number_of_drivers(self, number_of_drivers):
        numbers = [1, 2, 3, 4, 5, 8]
        if number_of_drivers not in numbers:
            raise serializers.ValidationError('Wrong value.')
        return number_of_drivers
