# Django
from django.utils.translation import gettext as _

# Django Rest Framework
from rest_framework import serializers

# Project
from ...models import OldInspection, InspectionPlace, Inspection, CarDetail


class OldInspectionSerializer(serializers.ModelSerializer):
    def to_representation(self, instance):
        self.fields['place'] = InspectionPlaceSerializer()
        return super().to_representation(instance)

    class Meta:
        model = OldInspection
        fields = (
            'id',
            'place',
            'date_passed',
            'date_end',
        )


class InspectionPlaceSerializer(serializers.ModelSerializer):
    class Meta:
        model = InspectionPlace
        fields = (
            'id',
            'name'
        )


class InspectionSerializer(serializers.ModelSerializer):
    class Meta:
        model = Inspection
        fields = (
            'id',
            'car_detail',
            'dateInpsection',
            'dateNextInpsection',
            'pDivision'
        )


class InspectionCheckSerializer(serializers.Serializer):
    car_detail = serializers.PrimaryKeyRelatedField(
        queryset=CarDetail.objects.all()
    )

    def validate_car_detail(self, car_detail):
        user = self.context['request'].user
        if not user.cars.filter(car_detail=car_detail).exists():
            raise serializers.ValidationError('Not found.')
        return car_detail
