# Django Rest Framework
from rest_framework import serializers

# Project
from ...models import CarModel, CarBrand
from apps.files.serializers import FileSerializer


class CarBrandSerializer(serializers.ModelSerializer):
    def to_representation(self, instance):
        self.fields['logo'] = FileSerializer(fields=('id', 'name', 'file'))
        return super().to_representation(instance)

    class Meta:
        model = CarBrand
        fields = (
            'id',
            'name',
            'logo'
        )


class CarModelSerializer(serializers.ModelSerializer):
    def to_representation(self, instance):
        self.fields['image'] = FileSerializer(fields=('id', 'name', 'file'))
        return super().to_representation(instance)

    class Meta:
        model = CarModel
        fields = (
            'id',
            'car_brand',
            'name',
            'image'
        )
