# Django
from django.db.models import Q

# Project
from apps.shared.models import QuerySetBase, BaseManager


class FineQuerySet(QuerySetBase):
    as_manager = BaseManager

    def failed_fines(self):
        return self.filter(
            pUrl__isnull=False,
            parent__isnull=True,
            is_exist_pdf=True,
            plate_number__isnull=True,
            plate_number_and_car__isnull=True
        )


class FineManager(BaseManager):
    def get_queryset(self):
        return FineQuerySet(self.model)

    def failed_fines(self):
        return self.get_queryset().failed_fines()
