# Stdlib
from openpyxl import load_workbook
import os

# Django
from django.core.management import BaseCommand
from django.db import transaction

# Project
from django.conf import settings
from ...models import CarDetail
from ...services.cars import unsubscribe_to_fines


class Command(BaseCommand):
    all = ['unsubscribe cars in excel file']

    @transaction.atomic
    def handle(self, *args, **options):
        filename = options['filename']
        self.export_table(filename)

    def add_arguments(self, parser):
        parser.add_argument('filename', type=str, nargs='?', default="")

    def export_table(self, filename):
        FILES_DIR = os.path.join(settings.BASE_DIR,
                                 'apps/cars/management/files/')

        wb_obj = load_workbook(filename=f'{FILES_DIR}{filename}.xlsx')
        sheet_obj = wb_obj.active

        for rx in range(1, sheet_obj.max_row + 1):
            field_key = sheet_obj.cell(row=rx, column=1).value

            assert isinstance(field_key, int), "NOT AN INTEGER"
            try:
                qs = CarDetail.raw_objects.filter(id=field_key)
                if qs.exists():
                    car_detail = qs.first()
                    if car_detail.is_deleted:
                        unsubscribe_to_fines(car_detail)
                else:
                    print(field_key)
            except Exception as e:
                print("EXCEPTION DB ERROR!!!!", field_key)
