# Stdlib
import os
import json
from django.core.files import File as FileCreator

# Django
from django.core.management.base import BaseCommand
from django.db import transaction
from django.core.files.storage import default_storage

# Project
from apps.cars.models import CarBrand, CarModel
from apps.files.models import File


def create_car_models(file_key, car_brand: CarBrand):
    try:
        json_file = default_storage.open(f'brand/json{file_key}.json')

        data = json.load(json_file)['data']['values']['data']

        for model in data:
            model_name = model['value']
            file = None
            try:
                image = default_storage.open(f"car/{model['alias']}.png")

                file = File.objects.create(
                    name=model_name,
                    file=FileCreator(image, name=image.name))
            except Exception:
                pass
            CarModel.objects.create(
                name=model_name,
                car_brand=car_brand,
                image=file,
                popular=model.get('popular') or 0
            )
    except Exception:
        pass


class Command(BaseCommand):
    help = 'Displays current time'

    def handle(self, *args, **kwargs):
        json_file = default_storage.open(f'brand/brands.json')
        data = json.load(json_file)['data']['values']['data']
        for brand in data[1:]:
            brand_name = brand['value']
            file = None
            try:
                image = default_storage.open(
                    f"brand/images/{brand_name.lower()}.png")
                file = File.objects.create(
                    name=brand_name,
                    file=FileCreator(image, name=image.name))

            except Exception:
                pass

            car_brand = CarBrand.objects.create(
                name=brand_name,
                popular=brand.get('popular') or 0,
                logo=file
            )
            create_car_models(brand['key'], car_brand)
