import xlrd
from openpyxl import load_workbook

from apps.cars.models import Violation

# Violation.objects.create()

wb = load_workbook("apps/cars/import/AdmKodeksASBT.xlsx")
sh = wb['articles_ASBT']

for row in sh.iter_rows(min_row=3):
    if not row[0].value:
        continue

    asbt_id = int(row[0].value)
    desc_oz = row[1].value
    desc_uz = row[2].value
    desc_ru = row[3].value
    article = str(row[4].value).replace('.0', '')
    part = row[5].value

    obj, _ = Violation.objects.update_or_create(
        id=asbt_id,
        defaults=dict(
            article=article,
            part=part
        )
    )

    obj.set_current_language('ru')
    obj.desc = desc_ru
    obj.save()

    obj.set_current_language('uz')
    obj.desc = desc_uz
    obj.save()

    obj.set_current_language('oz')
    obj.desc = desc_oz
    obj.save()

    print(obj.id, asbt_id)
    assert obj.id == asbt_id
