# Pypi: django_filters
from django_filters import rest_framework as filters

# Project
from .models import Fine


class FineFilterSet(filters.FilterSet):
    pStatus = filters.CharFilter(
        method='get_pStatus',
        help_text='for multi filter use: 1,2,3,5...'
    )
    car = filters.NumberFilter(method='get_car')

    def get_pStatus(self, queryset, name, value):
        statuses = value.split(',')

        if all(i.isdigit() for i in statuses):
            queryset = queryset.filter(pStatus__in=statuses)

        return queryset

    def get_car(self, queryset, name, value):
        return queryset.filter(car_detail__cars=value)

    class Meta:
        model = Fine
        fields = ['car', 'pStatus']
