# Django Rest Framework
from rest_framework.permissions import IsAdminUser
from rest_framework.viewsets import ModelViewSet

# Project
from ...models import CarModel, CarBrand
from ...mobile.serializers.handbooks import (
    CarBrandSerializer,
    CarModelSerializer
)


class CarModelViewSet(ModelViewSet):
    queryset = CarModel.objects.all()
    permission_classes = (IsAdminUser,)
    serializer_class = CarModelSerializer
    filterset_fields = ['car_brand']


class CarBrandViewSet(ModelViewSet):
    queryset = CarBrand.objects.all()
    permission_classes = (IsAdminUser,)
    serializer_class = CarBrandSerializer
