# Python
from collections import defaultdict, deque

# Django Rest Framework
from rest_framework.permissions import IsAdminUser
from rest_framework.viewsets import ReadOnlyModelViewSet

# Project
from apps.transactions.models import Check
from ...models import Fine
from ...filters import FineFilterSet
from ...mobile.serializers.fine import (
    FineSerializer,
    FineListSerializer
)


class FineAdminViewSet(ReadOnlyModelViewSet):
    permission_classes = (IsAdminUser,)
    filterset_class = FineFilterSet

    def get_queryset(self):
        return Fine.objects.filter(
            parent__isnull=True
        ).select_related('pViolation').distinct()

    def get_serializer_class(self):
        if self.action == 'list':
            return FineListSerializer
        return FineSerializer
