# Django
from django.urls import include, path
from rest_framework.routers import DefaultRouter

# Project
from .views.inspection import InspectionPlaceViewSet
from .views.handbooks import CarBrandViewSet, CarModelViewSet
from .views.cars import CarAdminViewSet
from .views.fines import FineAdminViewSet

router = DefaultRouter()
router.register(
    'inspection-places',
    InspectionPlaceViewSet,
    'inspection-places'
)
router.register('car_brands', CarBrandViewSet, 'car_brands')
router.register('car_models', CarModelViewSet, 'car_models')
router.register('fines', FineAdminViewSet, 'fines')
router.register('', CarAdminViewSet, 'car')

urlpatterns = [
    path('', include(router.urls)),
]
