# Django Rest Framework
from rest_framework import serializers

# Project
from ...mobile.serializers.car import CarSerializer
from ...models import Car


class CarAdminSerializer(CarSerializer):
    confidant = None
    inspection = None
    insurance = None
    tinting = None
    oil = None
    user_phone_number = serializers.CharField(source='user.phone')

    class Meta:
        model = Car
        fields = (
            'id',
            'number',
            'tech_pass_num',
            'tech_pass_series',
            'mark',
            'name',
            'image',
            'car_model',
            'car_brand',
            'fines_count',
            'fines_remain',
            'car_detail',
            'date_of_registration',
            'year_manufacture',
            'pinned',
            'user',
            'user_phone_number',
            'is_deleted'
        )
        read_only_fields = ('car_detail',)
