# Pypi: django_filters
from django_filters import rest_framework as filters

# Project
from ..models import Car


class CarAdminFilterSet(filters.FilterSet):
    pSeryNumber = filters.CharFilter(method='get_pSeryNumber')

    def get_pSeryNumber(self, queryset, name, value):
        return queryset.filter(car_detail__fines__pSeryNumber=value).distinct()

    class Meta:
        model = Car
        fields = ['car_detail__number', 'user__phone']
