# Stdlib
import os

# Django Rest Framework
from rest_framework import status
from rest_framework.exceptions import ValidationError

# Pypi: requests
from requests.exceptions import ReadTimeout

# Project
from apps.shared.utils import requests


def check_bank_card(card_number):
    url = 'https://core.unired.uz/api/v1/munis'
    headers = {"Authorization": "Bearer %s" % os.environ['MUNIS_TOKEN']}
    data = {
        "jsonrpc": "2.0",
        "id": "1",
        "method": "card.info",
        "params": {
            "card_number": card_number
        }
    }
    response = requests.post(url, json=data, headers=headers)

    data = response.json()
    assert response.status_code == status.HTTP_200_OK, data

    if not data['status']:
        return False, data['error']['message']
    return True, data['result']


def get_bank_card_detail(card_number, expire):
    url = 'https://core.unired.uz/api/v1/munis'
    headers = {"Authorization": "Bearer %s" % os.environ['MUNIS_TOKEN']}
    data = {
        "jsonrpc": "2.0",
        "id": "1",
        "method": "card.register",
        "params": {
            "card_number": card_number,
            "expire": expire
        }
    }
    try:
        response = requests.post(url, json=data, headers=headers)
    except ReadTimeout:
        return False, {
            'uz': 'На стороне банка не поладки (timeout).',
            'ru': 'На стороне банка не поладки (timeout).'
        }

    if response.status_code != status.HTTP_200_OK:
        return False, {
            'uz': 'На стороне банка не поладки (500).',
            'ru': 'На стороне банка не поладки (500).'
        }
    data = response.json()
    if not data['status']:
        return False, data['error']['message']
    if data['result']['state'] == -1:
        return False, {
            'uz': 'Карта заблокированна.',
            'ru': 'Карта заблокированна.',
        }
    return True, data['result']
