# Django
from django.utils.translation import gettext as _
from django.conf import settings

# Project
from .models import BankCard
from apps.shared.utils import send_sms_verification as sms_send


def send_sms_verification(card: BankCard):
    assert not card.is_verified, _('Already verified.')
    sms_send(
        card,
        card.phone,
        (_('Road24 dobavlenie karti SMS-kod: %s') +
         f" {settings.SMS_APP_CODE}")
    )
