# Django
from django.db import models
from django.db.models import Q, UniqueConstraint

# Project
from apps.shared.models import BaseModel, BaseMeta


class BankCard(BaseModel):
    user = models.ForeignKey(
        'gauth.User',
        on_delete=models.PROTECT,
        related_name='cards'
    )
    number = models.CharField(max_length=16)
    full_name = models.CharField(max_length=40)
    expire = models.CharField(max_length=4)
    phone = models.CharField(max_length=30)
    filial = models.CharField(max_length=20, blank=True)

    sms_date = models.DateTimeField(null=True)
    sms_code = models.CharField(max_length=128, blank=True)
    is_verified = models.BooleanField(default=False)

    class Meta(BaseMeta):
        constraints = [
            UniqueConstraint(
                fields=['user', 'number'],
                condition=Q(is_deleted=False),
                name='unique_number'
            )
        ]
