# Python
from json import loads, dumps

# Django Rest Framework
from rest_framework.test import APITestCase
from rest_framework import status

# Project
from ..models import Alert
from apps.shared.tests import ViewSetTestCase, AuthTestCase


class ProblemAlertTest(APITestCase, ViewSetTestCase, AuthTestCase):
    fixtures = [
        'user.yaml',
        'region.yaml',
        'district.yaml',
        'file.yaml',
        'address.yaml',
        'problem.yaml',
        'vote.yaml',
        'alerts.yaml',
        'translations.yaml'
    ]

    url = 'mobile:alerts-%s'

    def setUp(self):
        self._auth_admin()

    def test_unauth(self):
        self.client.credentials()

        response = self._create({})
        self.assertEqual(response.status_code, status.HTTP_403_FORBIDDEN)

    def test_retrieve(self):
        response = self._retrieve({
            'pk': 1,
            'headers': {
                'HTTP_ACCEPT_LANGUAGE': 'uz'
            }
        })
        data = {
            "id": 1,
            "title": "uz_lang_title",
            "description": "uz_lang_desc",
            "photo": {
                "id": 1,
                "name": "my_file",
                "file": "http://testserver/media/test.jpg",
                "video_preview": None,
                "module": ""
            },
            "job_type": "closing",
            "is_published": True,
            "created_date": "2017-01-01T00:00:00.100000+05:00"
        }
        self.assertEqual(loads(dumps(response.data)), data)

    def test_list_uz(self):
        data = {
            "id": 3,
            "title": "uz_lang_title",
            "description": "uz_lang_desc",
            "photo": {
                "id": 3,
                "name": "my_file3",
                "file": "http://testserver/media/test.jpg",
                "video_preview": None,
                "module": ""
            },
            "job_type": "closing",
            "is_published": False,
            "created_date": "2017-01-01T00:00:00.100000+05:00"
        }
        response = self._list(kwargs={
            'headers': {
                'HTTP_ACCEPT_LANGUAGE': 'uz'
            }
        })
        self.assertEqual(response.status_code, status.HTTP_200_OK)
        self.assertEqual(response.data['count'], 3)
        self.assertEqual(len(response.data['results']), 3)
        alert = response.data['results'][0]
        self.assertEqual(loads(dumps(alert)), data)

    def test_list_ru(self):
        data = {
            "id": 3,
            "title": "ru_lang",
            "description": "ru_lang_desc",
            "photo": {
                "id": 3,
                "name": "my_file3",
                "file": "http://testserver/media/test.jpg",
                "video_preview": None,
                "module": ""
            },
            "job_type": "closing",
            "is_published": False,
            "created_date": "2017-01-01T00:00:00.100000+05:00"
        }
        response = self._list(kwargs={
            'headers': {
                'HTTP_ACCEPT_LANGUAGE': 'ru'
            }
        })
        self.assertEqual(response.status_code, status.HTTP_200_OK)
        self.assertEqual(response.data['count'], 3)
        self.assertEqual(len(response.data['results']), 3)
        alert = response.data['results'][0]
        self.assertEqual(loads(dumps(alert)), data)
