# Django
from django.db import models

# Pypi django-parler
from parler.models import TranslatableModel, TranslatedFields

# Project
from apps.shared.models import BaseTranslateModel


class Alert(BaseTranslateModel):
    CLOSING = 'closing'
    REMOUNT = 'remount'

    JOB_TYPES = (
        (CLOSING, 'Закрытие'),
        (REMOUNT, 'Ремонтные работы')
    )

    translations = TranslatedFields(
        title=models.CharField(max_length=255),
        description=models.TextField(),
    )
    photo = models.ForeignKey('files.File', on_delete=models.DO_NOTHING)
    job_type = models.CharField(max_length=30, choices=JOB_TYPES)
    is_published = models.BooleanField(default=True)

    class Meta:
        ordering = ('-id',)
