# Django
from rest_framework.permissions import IsAuthenticatedOrReadOnly
from rest_framework.viewsets import ReadOnlyModelViewSet

# Project
from ..models import Alert
from ..admin.serializers import AlertSerializer
from ..filter import AlertFilter


class AlertViewSet(ReadOnlyModelViewSet):
    permission_classes = (IsAuthenticatedOrReadOnly,)
    serializer_class = AlertSerializer
    filterset_class = AlertFilter

    def get_queryset(self):
        return Alert.objects.translated(title__isnull=False)
