# Django Rest Framework
from rest_framework.viewsets import ModelViewSet
from rest_framework.permissions import IsAdminUser

# Project
from ..models import Alert
from .serializers import AlertSerializer, AlertCreateUpdateSerializer
from ..filter import AlertFilter


class AlertViewSet(ModelViewSet):
    queryset = Alert.objects.translated(title__isnull=False)
    permission_classes = (IsAdminUser,)
    serializer_class = AlertSerializer
    filterset_class = AlertFilter

    def get_serializer_class(self):
        if self.action in ['create', 'update', 'partial-update']:
            return AlertCreateUpdateSerializer
        return AlertSerializer
