# Django Rest Framework
from rest_framework import serializers

# Project
from ..models import Alert
from apps.files.serializers import FileSerializer

# Pypi parler_rest
from parler_rest.serializers import TranslatableModelSerializer
from parler_rest.fields import TranslatedFieldsField


class AlertSerializer(serializers.ModelSerializer):
    title = serializers.CharField()
    description = serializers.CharField()

    def to_representation(self, instance):
        self.fields['photo'] = FileSerializer()
        return super().to_representation(instance)

    class Meta:
        model = Alert
        fields = (
            'id',
            'title',
            'description',
            'photo',
            'job_type',
            'is_published',
            'created_date',
        )


class AlertCreateUpdateSerializer(TranslatableModelSerializer):
    translations = TranslatedFieldsField(shared_model=Alert)

    class Meta:
        model = Alert
        fields = (
            'id',
            'translations',
            'photo',
            'job_type',
            'is_published',
        )
